/*:
 * @pluginParam replaceString
 * @text 置換文字列
 * @desc ♡を置き換える文字列
 * @default ❤
 *
 * @help
 * メッセージウィンドウで♡を別の文字列に置き換えます。
 */

(function() {
    var parameters = PluginManager.parameters('ReplaceMessageWindowText');
    var replaceString = String(parameters['replaceString'] || '❤');

    var _Window_Message_prototype_convertEscapeCharacters = Window_Message.prototype.convertEscapeCharacters;
    Window_Message.prototype.convertEscapeCharacters = function(text) {
        text = _Window_Message_prototype_convertEscapeCharacters.call(this, text);
        return text.replace(/♡/g, replaceString);
    };
})();